/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.COMPOSITIONFORM;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Widget;

public class Caret
extends Widget {
    Canvas parent;
    int x;
    int y;
    int width;
    int height;
    boolean moved;
    boolean resized;
    boolean isVisible;
    Image image;
    Font font;
    LOGFONT oldFont;

    public Caret(Canvas canvas, int n) {
        super(canvas, n);
        this.parent = canvas;
        this.createWidget();
    }

    void createWidget() {
        this.isVisible = true;
        if (this.parent.getCaret() == null) {
            this.parent.setCaret(this);
        }
    }

    int defaultFont() {
        int n = this.parent.handle;
        int n2 = OS.ImmGetDefaultIMEWnd(n);
        int n3 = 0;
        if (n2 != 0) {
            n3 = OS.SendMessage(n2, 49, 0, 0);
        }
        if (n3 == 0) {
            n3 = OS.SendMessage(n, 49, 0, 0);
        }
        if (n3 == 0) {
            return this.parent.defaultFont();
        }
        return n3;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rectangle = this.image.getBounds();
            return new Rectangle(this.x, this.y, rectangle.width, rectangle.height);
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font == null) {
            int n = this.defaultFont();
            return Font.win32_new(this.display, n);
        }
        return this.font;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Point getLocation() {
        this.checkWidget();
        return new Point(this.x, this.y);
    }

    public Canvas getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Point getSize() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rectangle = this.image.getBounds();
            return new Point(rectangle.width, rectangle.height);
        }
        return new Point(this.width, this.height);
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.isVisible;
    }

    boolean hasFocus() {
        return this.parent.handle == OS.GetFocus();
    }

    boolean isFocusCaret() {
        return this.parent.caret == this && this.hasFocus();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.isVisible && this.parent.isVisible() && this.hasFocus();
    }

    void killFocus() {
        OS.DestroyCaret();
        this.restoreIMEFont();
    }

    void move() {
        this.moved = false;
        if (!OS.SetCaretPos(this.x, this.y)) {
            return;
        }
        this.resizeIME();
    }

    void resizeIME() {
        if (!OS.IsDBLocale) {
            return;
        }
        POINT pOINT = new POINT();
        if (!OS.GetCaretPos(pOINT)) {
            return;
        }
        int n = this.parent.handle;
        RECT rECT = new RECT();
        OS.GetClientRect(n, rECT);
        COMPOSITIONFORM cOMPOSITIONFORM = new COMPOSITIONFORM();
        cOMPOSITIONFORM.dwStyle = 1;
        cOMPOSITIONFORM.x = pOINT.x;
        cOMPOSITIONFORM.y = pOINT.y;
        cOMPOSITIONFORM.left = rECT.left;
        cOMPOSITIONFORM.right = rECT.right;
        cOMPOSITIONFORM.top = rECT.top;
        cOMPOSITIONFORM.bottom = rECT.bottom;
        int n2 = OS.ImmGetContext(n);
        OS.ImmSetCompositionWindow(n2, cOMPOSITIONFORM);
        OS.ImmReleaseContext(n, n2);
    }

    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getCaret()) {
            this.parent.setCaret(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.image = null;
        this.font = null;
        this.oldFont = null;
    }

    void resize() {
        this.resized = false;
        int n = this.parent.handle;
        OS.DestroyCaret();
        int n2 = this.image != null ? this.image.handle : 0;
        OS.CreateCaret(n, n2, this.width, this.height);
        OS.SetCaretPos(this.x, this.y);
        OS.ShowCaret(n);
        this.move();
    }

    void restoreIMEFont() {
        if (!OS.IsDBLocale) {
            return;
        }
        if (this.oldFont == null) {
            return;
        }
        int n = this.parent.handle;
        int n2 = OS.ImmGetContext(n);
        OS.ImmSetCompositionFont(n2, this.oldFont);
        OS.ImmReleaseContext(n, n2);
        this.oldFont = null;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        boolean bl;
        this.checkWidget();
        boolean bl2 = this.x == n && this.y == n2;
        boolean bl3 = bl = this.width == n3 && this.height == n4;
        if (bl2 && bl) {
            return;
        }
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        if (bl) {
            this.moved = true;
            if (this.isVisible && this.hasFocus()) {
                this.move();
            }
        } else {
            this.resized = true;
            if (this.isVisible && this.hasFocus()) {
                this.resize();
            }
        }
    }

    public void setBounds(Rectangle rectangle) {
        if (rectangle == null) {
            this.error(4);
        }
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void setFocus() {
        int n = this.parent.handle;
        int n2 = 0;
        if (this.image != null) {
            n2 = this.image.handle;
        }
        OS.CreateCaret(n, n2, this.width, this.height);
        this.move();
        this.setIMEFont();
        if (this.isVisible) {
            OS.ShowCaret(n);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
        if (this.hasFocus()) {
            this.setIMEFont();
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (this.isVisible && this.hasFocus()) {
            this.resize();
        }
    }

    void setIMEFont() {
        LOGFONT lOGFONT;
        if (!OS.IsDBLocale) {
            return;
        }
        int n = 0;
        if (this.font != null) {
            n = this.font.handle;
        }
        if (n == 0) {
            n = this.defaultFont();
        }
        int n2 = this.parent.handle;
        int n3 = OS.ImmGetContext(n2);
        if (this.oldFont == null) {
            LOGFONT lOGFONT2 = this.oldFont = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            if (!OS.ImmGetCompositionFont(n3, this.oldFont)) {
                this.oldFont = null;
            }
        }
        LOGFONT lOGFONT3 = lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
        if (OS.GetObject(n, LOGFONT.sizeof, lOGFONT) != 0) {
            OS.ImmSetCompositionFont(n3, lOGFONT);
        }
        OS.ImmReleaseContext(n2, n3);
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        if (this.x == n && this.y == n2) {
            return;
        }
        this.x = n;
        this.y = n2;
        this.moved = true;
        if (this.isVisible && this.hasFocus()) {
            this.move();
        }
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setSize(int n, int n2) {
        this.checkWidget();
        if (this.width == n && this.height == n2) {
            return;
        }
        this.width = n;
        this.height = n2;
        this.resized = true;
        if (this.isVisible && this.hasFocus()) {
            this.resize();
        }
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSize(point.x, point.y);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (bl == this.isVisible) {
            return;
        }
        this.isVisible = bl;
        int n = this.parent.handle;
        if (OS.GetFocus() != n) {
            return;
        }
        if (!this.isVisible) {
            OS.HideCaret(n);
        } else {
            if (this.resized) {
                this.resize();
            } else if (this.moved) {
                this.move();
            }
            OS.ShowCaret(n);
        }
    }
}

